/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.proxy;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.controllers.ImageController;
import com.roninpixels.dashboardhub.exceptions.ImageTypeException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.ImageMimeTypeModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/proxy/image")
public class ImageProxyEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ImageProxyEndpoint.class);
    @Autowired
    private ImageController imageController;
    @Autowired
    private DHObjectMapper mapper;

    private static final String getExpirationTime() {
        return ZonedDateTime.now().plusYears(1L).format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @GET
    @AnonymousAllowed
    public Response get(@NotNull @HeaderParam(value="dsextraconfig") String dsextraconfig, @Context UriInfo ui) {
        try {
            MultivaluedMap params = ui.getQueryParameters();
            String route = (String)((LinkedList)params.get((Object)"route")).get(0);
            Map dsExtraConfigMap = this.mapper.readValue(new String(Base64.getDecoder().decode(dsextraconfig)), HashMap.class);
            ImageMimeTypeModel image = this.imageController.getImageByteArray((String)dsExtraConfigMap.get("datasourceId"), route);
            return Response.status((int)200).entity((Object)image.getImageByteArray()).header("Content-Type", (Object)image.getMimeType()).header("Content-Length", (Object)String.valueOf(image.getImageByteArray().length)).build();
        }
        catch (ImageTypeException ime) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", ime.getMessage());
            return ResponseBuilder.create(400, error).build();
        }
        catch (Exception e) {
            return Response.status((int)404).build();
        }
    }
}

