/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.projectrak.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ProjectrakConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import com.roninpixels.dashboardhub.web.rest.projectrak.api.PQLRequest;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/projectrak/v1/pql")
public class PQLEndpoint {
    private static final Logger log = LoggerFactory.getLogger(PQLEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @POST
    @Path(value="/validate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response validate(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, PQLRequest pqlRequest) {
        String urlTarget = "not defined";
        try {
            ProjectrakConnector projectrak = (ProjectrakConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            urlTarget = projectrak.getURL();
            Map response = projectrak.validPQL(pqlRequest.getPQL());
            return ResponseBuilder.ok(response).build();
        }
        catch (BadRequestToSourceException bre) {
            log.error("Problems validating a PQL for projectrak for " + urlTarget, (Throwable)bre);
            return GenericJiraEndpoint.generateResponse(bre);
        }
        catch (Exception e) {
            log.error("Problems validating a PQL for projectrak for " + urlTarget, (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @POST
    @Path(value="/search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response search(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, PQLRequest pqlRequest) {
        String urlTarget = "not defined";
        try {
            ProjectrakConnector projectrak = (ProjectrakConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            urlTarget = projectrak.getURL();
            List<Map> response = projectrak.execPQL(pqlRequest.getPQL(), pqlRequest.getFields(), true);
            return ResponseBuilder.ok(response).build();
        }
        catch (BadRequestToSourceException bre) {
            log.error("Problems validating a PQL for projectrak for " + urlTarget, (Throwable)bre);
            return GenericJiraEndpoint.generateResponse(bre);
        }
        catch (Exception e) {
            log.error("Problems validating a PQL for projectrak for " + urlTarget, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

