/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.services.utils;

import com.roninpixels.dashboardhub.services.BoardUtilsService;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.BoardSharingModel;
import com.roninpixels.dashboardhub.web.models.EncryptedBoardModel;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BoardUtilsServiceImpl
implements BoardUtilsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoardUtilsServiceImpl.class);
    @Inject
    private Crypto mCrypto;
    @Inject
    private DHObjectMapper mMapper;

    @Override
    public BoardModel recoverBoard(EncryptedBoardModel encryptedBoard) {
        BoardModel result = null;
        if (encryptedBoard != null) {
            try {
                String json = this.mCrypto.decryptBackend(encryptedBoard.getData());
                result = this.mMapper.readValue(json, BoardModel.class);
            }
            catch (Exception e) {
                LOGGER.error("Problems with board: " + encryptedBoard.getId(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public EncryptedBoardModel generateEncryptedBoard(BoardModel board) throws Exception {
        EncryptedBoardModel encrypted = new EncryptedBoardModel();
        encrypted.setId(board.getId());
        encrypted.setName(board.getName());
        encrypted.setOwner(board.getOwner());
        encrypted.setCreated(board.getCreated());
        encrypted.setUpdated(board.getUpdated());
        encrypted.setGlobal(board.getGlobal());
        board.setSharing(this.getSharingByAction(board.getSharing()));
        String json = this.mMapper.writeValueAsString(board);
        encrypted.setData(this.mCrypto.encryptBackend(json));
        return encrypted;
    }

    private BoardSharingModel getSharingByAction(BoardSharingModel sharing) {
        BoardSharingModel newSharing;
        if (sharing != null && sharing.getAction() != null) {
            newSharing = new BoardSharingModel();
            newSharing.setPublic(sharing.getPublic());
            newSharing.setPassword(sharing.getPassword());
            switch (sharing.getAction()) {
                case "delete_password": {
                    newSharing.setPassword(null);
                    break;
                }
                default: {
                    String hashedPass = this.mCrypto.hashString(sharing.getPassword());
                    newSharing.setPassword(hashedPass);
                    break;
                }
            }
        } else {
            newSharing = sharing;
        }
        return newSharing;
    }
}

