/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.GadgetBadConfigException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.AgileGadgetReponseData;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDateUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraSprintDataUtilsSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.JQLAndSprints;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.AgileGadgetConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.configs.SprintDef;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class SprintResolvedIssues
extends JiraBaseGadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(SprintResolvedIssues.class);
    static final List<String> DEFAULT_FIELDS = Arrays.asList("status");
    static final List<String> EXPAND = Arrays.asList("changelog");
    private static final String[] SPRINT_STATES = new String[]{"active", "closed"};
    @Inject
    protected JiraSprintDataUtilsSrv jiraSprintUtils;

    Map getPreviousSprint(Map targetSprint, List<Map> sprints) {
        long targetStartDateMillis = JiraDateUtils.getMillisFrom((String)targetSprint.get("startDate"));
        long previousMillis = Long.MIN_VALUE;
        Map previousSprint = null;
        for (Map aSprint : sprints) {
            long completedDateMillis;
            if (!"closed".equals(aSprint.get("state")) || (completedDateMillis = JiraDateUtils.getMillisFrom((String)aSprint.get("completeDate"))) >= targetStartDateMillis || completedDateMillis <= previousMillis) continue;
            previousMillis = completedDateMillis;
            previousSprint = aSprint;
        }
        return previousSprint;
    }

    private List<Map> getBoardSprints(Long boardId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", String.join((CharSequence)",", SPRINT_STATES));
        ResponseEntity<List> response2 = this.jiraConnector.getBoardsSprints(boardId, params, null);
        ResponseChecker.checkStatus(response2);
        return (List)response2.getBody();
    }

    JQLAndSprints getJQLAndSprintsData_boards(AgileGadgetConfig config, String sprintClause) throws Exception {
        Long boardId = config.getAllBoards().get(0);
        ResponseEntity<String> response = this.jiraConnector.getBoardConfiguration(boardId);
        Map boardConfig = ResponseChecker.checkStatusAndParse(response, Map.class);
        List<Map> allSprints = this.getBoardSprints(boardId);
        Map activeSprint = JiraSprintDataUtils.getActiveSprint(allSprints);
        if (activeSprint == null) {
            return null;
        }
        LinkedList<Map> sprints = new LinkedList<Map>();
        sprints.add(activeSprint);
        Map previousSprint = this.getPreviousSprint(activeSprint, allSprints);
        if (previousSprint != null) {
            sprints.add(0, previousSprint);
        }
        String filterId = ((Map)boardConfig.get("filter")).get("id").toString();
        String jql = this.jiraSprintUtils.generateJQL(sprints, sprintClause, filterId);
        return new JQLAndSprints(sprints, jql);
    }

    JQLAndSprints getJQLAndSprintsData_sprints(AgileGadgetConfig config, String sprintClause) {
        List<Map> sprints = new LinkedList<Map>();
        SprintDef sprintDef = config.getSprints().get(0);
        Map targetSprint = this.jiraConnector.getSprint(sprintDef.getValue());
        sprints.add(targetSprint);
        if (targetSprint.containsKey("originBoardId")) {
            try {
                List<Map> allSprints = this.getBoardSprints(((Number)targetSprint.get("originBoardId")).longValue());
                Map previousSprint = this.getPreviousSprint(targetSprint, allSprints);
                sprints.add(0, previousSprint);
            }
            catch (Exception e) {
                log.error(String.format("It is not possible to get the previous sprint: %s (%s)", e.getClass(), e.getMessage()));
            }
        }
        sprints = JiraSprintDataUtils.getSprintsWithProjects(this.jiraConnector, sprints);
        String jql = this.jiraSprintUtils.generateJQL(sprints, sprintClause, null);
        return new JQLAndSprints(sprints, jql);
    }

    private JQLAndSprints getJQLAndSprints(AgileGadgetConfig config, List<String> extraParams) {
        JQLAndSprints jqlAndSprints;
        block5: {
            String sprintClause = extraParams.isEmpty() ? "Sprint" : extraParams.get(0);
            jqlAndSprints = null;
            try {
                String reportingType = config.getReportingEntityType();
                if (reportingType == null || "boards".equals(reportingType)) {
                    jqlAndSprints = this.getJQLAndSprintsData_boards(config, sprintClause);
                    break block5;
                }
                if ("sprints".equals(reportingType)) {
                    jqlAndSprints = this.getJQLAndSprintsData_sprints(config, sprintClause);
                    break block5;
                }
                throw new GadgetBadConfigException("Wrong reporting type: " + reportingType);
            }
            catch (BadRequestToSourceException | GadgetBadConfigException ex) {
                throw ex;
            }
            catch (Exception e) {
                log.error("Problems getting info related to the sprints", (Throwable)e);
            }
        }
        return jqlAndSprints;
    }

    private List<String> getFields(AgileGadgetConfig config, List<String> extraParams) {
        ArrayList<String> fields = new ArrayList<String>(DEFAULT_FIELDS);
        if (extraParams.size() > 1) {
            fields.add(extraParams.get(1));
        }
        if (config.getMetric() != null) {
            fields.addAll(JiraSprintDataUtils.extractFieldsNamesFromMetric(config.getMetric()));
        }
        return fields;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        AgileGadgetConfig config = GadgetRequesterUtils.getConfig(gadget, AgileGadgetConfig.class);
        try {
            List instanceFields = this.getFields();
            JQLAndSprints jqlAndSprints = this.getJQLAndSprints(config, extraParams);
            if (jqlAndSprints == null) {
                return new AgileGadgetReponseData();
            }
            List<Map> sprints = jqlAndSprints.getSprints();
            List<String> fields = this.getFields(config, extraParams);
            List<Map> issues = this.execJQLwithFilterFields(jqlAndSprints.getJql(), fields, instanceFields, EXPAND, null, null, null).getIssues();
            this.jiraSprintUtils.fixSprintField(issues, sprints, extraParams.get(1));
            return new AgileGadgetReponseData(sprints, issues);
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

