/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.fasterxml.jackson.core.type.TypeReference;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.GadgetBadConfigException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.agileProviders.AgileIssuesProvider;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.utils.filter.FilterUtils;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

public abstract class JiraBaseGadgetRequester
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(JiraBaseGadgetRequester.class);
    protected DHObjectMapper mapper = new DHObjectMapperImpl();
    @Inject
    private ConnectorsProvider provider;
    @Inject
    private BeanFactory beanFactory;
    protected JiraConnector jiraConnector;
    protected Map context;

    @Override
    public void init(DatasourceModel datasource, Map context) {
        this.jiraConnector = (JiraConnector)this.provider.getConnector(datasource);
        if (this.jiraConnector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + this.getClass().getAnnotation(Component.class));
        }
        this.context = context;
    }

    protected void checkStatus(ResponseEntity<?> response) throws BadRequestToSourceException {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }

    protected <T> T checkStatusAndParse(ResponseEntity<String> response, Class<T> clazz) throws Exception {
        this.checkStatus(response);
        return this.mapper.readValue((String)response.getBody(), clazz);
    }

    protected JQLResponse execJQLwithFilterFields(String jql, List<String> fields, List<Field> fieldList, List<String> expand, List<String> properties, Map<String, Object> extraOpts, String userKey) {
        String contentFilteringJQL = JqlUtils.appendContextFilterToJql(jql, this.context);
        List<String> filterCustomFieldsIds = JiraDataUtils.getFilterCustomFieldsIds(fieldList);
        List userFilterFieldsWithCustomFields = ListUtils.union(FilterUtils.USER_FILTER_FIELDS, filterCustomFieldsIds);
        return this.jiraConnector.execJQL(contentFilteringJQL, ListUtils.union(fields, (List)userFilterFieldsWithCustomFields), expand, properties, extraOpts, userKey);
    }

    protected AgileIssuesProvider getAgileIssuesProvider(String providerType) {
        List<String> compatibleTypes = this.getCompatibleReportingTypes();
        if (compatibleTypes != null && !compatibleTypes.contains(providerType)) {
            throw new GadgetBadConfigException("Reporting type not supported: " + providerType);
        }
        AgileIssuesProvider provider = (AgileIssuesProvider)this.beanFactory.getBean(providerType, AgileIssuesProvider.class);
        provider.setJiraConnector(this.jiraConnector);
        return provider;
    }

    protected List getFields() throws Exception {
        String rawReponse = (String)this.jiraConnector.getFields().getBody();
        return this.mapper.readValue(rawReponse, new TypeReference<List<Field>>(){});
    }

    protected List<String> getCompatibleReportingTypes() {
        return null;
    }
}

