/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JiraBaseGadgetRequester;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;

public abstract class JSMBaseGadgetRequester
extends JiraBaseGadgetRequester {
    private List<Map> serviceDesks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map> getServiceDesks() {
        JSMBaseGadgetRequester jSMBaseGadgetRequester = this;
        synchronized (jSMBaseGadgetRequester) {
            if (this.serviceDesks == null) {
                this.serviceDesks = this.jiraConnector.getAllServiceDesks(Collections.emptyMap());
            }
        }
        return Collections.unmodifiableList(this.serviceDesks);
    }

    protected Map getServiceDeskByProjectId(String projectId) {
        List<Map> serviceDesks = this.getServiceDesks();
        return serviceDesks.stream().filter(sd -> projectId.equals(sd.get("projectId"))).findAny().orElse(null);
    }

    protected String getServiceDeskIdBy(String projectId) {
        Map serviceDesk = this.getServiceDeskByProjectId(projectId);
        return serviceDesk != null ? (String)serviceDesk.get("id") : null;
    }

    protected Map getQueue(String projectId, String queueId, String serviceDeskId) throws Exception {
        if (serviceDeskId == null || serviceDeskId.equals("0")) {
            serviceDeskId = this.getServiceDeskIdBy(projectId);
        }
        ResponseEntity<Map> response = this.jiraConnector.getQueue(serviceDeskId, queueId);
        this.checkStatus(response);
        return (Map)response.getBody();
    }

    @Override
    public abstract Object getData(GadgetModel var1, List<String> var2);
}

