/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMMultiproject;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.CustomerSatisfactionConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerSatisfaction
extends JSMMultiproject {
    private static final Logger log = LoggerFactory.getLogger(CustomerSatisfaction.class);

    protected List getIssues(String dateFrom, String queuesJql, String feedbackFieldName, List<String> fieldNames, List<Field> fields) {
        String jql = String.format("%s != NULL AND updatedDate >= '%s' AND (%s)", feedbackFieldName, dateFrom, queuesJql);
        return this.execJQLwithFilterFields(jql, fieldNames, fields, null, null, null, null).getIssues();
    }

    protected List getPreviousIssues(String dateFrom, String dateFromPrevious, String queuesJql, String feedbackFieldName, List<String> fieldNames, List<Field> fields) {
        String jql = String.format("%s != NULL AND updatedDate < '%s' AND updatedDate >= '%s' AND (%s)", feedbackFieldName, dateFrom, dateFromPrevious, queuesJql);
        return this.execJQLwithFilterFields(jql, fieldNames, fields, null, null, null, null).getIssues();
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        CustomerSatisfactionConfig config = GadgetRequesterUtils.getConfig(gadget, CustomerSatisfactionConfig.class);
        try {
            List fields = this.getFields();
            Map jqlQueuesMap = this.getJqlQueues(config);
            String dateFrom = JSMDataUtil2.getDateAsString(config.getTimeRange());
            String feedbackFieldName = config.getFeedbackField().get(1);
            List issues = this.getIssues(dateFrom, (String)jqlQueuesMap.get("jql"), feedbackFieldName, Arrays.asList(config.getFeedbackField().get(0), config.getFeedbackDateField().get(0)), fields);
            String dateFromPrevious = JSMDataUtil2.getPreviousDateAsString(config.getTimeRange(), 2);
            List previousIssues = this.getPreviousIssues(dateFrom, dateFromPrevious, (String)jqlQueuesMap.get("jql"), feedbackFieldName, Arrays.asList(config.getFeedbackField().get(0), config.getFeedbackDateField().get(0)), fields);
            HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
            data.put("issues", issues);
            data.put("previousIssues", previousIssues);
            data.put("queues", (List<Object>)jqlQueuesMap.get("queues"));
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems getting data", e);
        }
    }
}

