/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.factories.JiraRestConnectorFactory;
import com.roninpixels.dashboardhub.connectors.factories.ProjectrakRestConnectorFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ProjectrakConnector;
import com.roninpixels.dashboardhub.services.controllers.JiraDatasourcesController;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class JiraDatasourcesControllerImpl
implements JiraDatasourcesController {
    @Inject
    private ProjectrakRestConnectorFactory projectrakRestConnectorFactory;
    @Inject
    private JiraRestConnectorFactory jiraRestConnectorFactory;
    @Inject
    private ConnectorsProvider provider;

    @Override
    public JiraConnector getJiraConnector(DatasourceModel datasourceModel) throws Exception {
        JiraConnector jiraConnector = null;
        if (this.projectrakRestConnectorFactory.match(datasourceModel)) {
            ProjectrakConnector connector = (ProjectrakConnector)this.provider.getConnector(datasourceModel);
            jiraConnector = connector.getJiraConnector();
        } else if (this.jiraRestConnectorFactory.match(datasourceModel)) {
            jiraConnector = (JiraConnector)this.provider.getConnector(datasourceModel);
        }
        if (jiraConnector == null) {
            throw new Exception("Jira connector not found for " + datasourceModel.getProduct());
        }
        return jiraConnector;
    }
}

