/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.controllers.BoardUserPreferencesController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.store.DHBoardUserPreferencesRepository;
import com.roninpixels.dashboardhub.web.models.BoardUserPreferenceModel;
import java.io.IOException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class BoardUserPreferencesControllerImpl
implements BoardUserPreferencesController {
    private static final Logger log = LoggerFactory.getLogger(BoardUserPreferencesControllerImpl.class);
    @Inject
    private DHBoardUserPreferencesRepository boardUserPreferencesRepo;
    @Inject
    private DHUserService dhUserService;

    @Override
    public BoardUserPreferenceModel getBoardUserPreference(String boardId) {
        try {
            BoardUserPreferenceModel boardUserPreference = this.boardUserPreferencesRepo.getBoardUserPreference(this.dhUserService.getLoggedInUserKey(), boardId);
            return boardUserPreference;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BoardUserPreferenceModel createOrUpdateBoardUserPreference(String boardId, String filter) throws IOException {
        BoardUserPreferenceModel boardUserPreference = this.boardUserPreferencesRepo.getBoardUserPreference(this.dhUserService.getLoggedInUserKey(), boardId);
        if (boardUserPreference == null) {
            return this.boardUserPreferencesRepo.addBoardUserPreference(this.dhUserService.getLoggedInUserKey(), boardId, filter);
        }
        return this.boardUserPreferencesRepo.updateBoardUserPreference(this.dhUserService.getLoggedInUserKey(), boardId, filter);
    }

    @Override
    public void removeBoardUserPreferences(String boardId) {
        this.boardUserPreferencesRepo.removeBoardUserPreferenceByBoard(boardId);
    }
}

