/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.controllers.AdminBoardsController;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.exceptions.BadRequestException;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.store.DHBoardsRepository;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.EncryptedBoardModel;
import com.roninpixels.dashboardhub.web.models.ResponseBoardModel;
import com.roninpixels.dashboardhub.web.models.ResponseChangeOwnerModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class AdminBoardsControllerImpl
implements AdminBoardsController {
    private static final Logger log = LoggerFactory.getLogger(AdminBoardsControllerImpl.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private BoardsController boardsController;
    @Inject
    private DHBoardsRepository boardsRepo;

    private List<ResponseBoardModel> populateOwnersData(List<EncryptedBoardModel> boards) {
        List boardDistinctOwners = boards.stream().map(EncryptedBoardModel::getOwner).distinct().collect(Collectors.toList());
        LinkedList<AppUser> ownersData = new LinkedList<AppUser>();
        for (String owner : boardDistinctOwners) {
            AppUser ownerData = this.dhUserService.getUserByKey(owner, true);
            if (ownerData == null) continue;
            ownersData.add(ownerData);
        }
        List<ResponseBoardModel> boardsWithOwnerData = boards.stream().map(encryptedBoard -> {
            AppUser ownerData = ownersData.stream().filter(owner -> owner.getKey().equals(encryptedBoard.getOwner())).findFirst().orElse(null);
            BoardModel decryptedBoard = this.boardsController.decryptBoard((EncryptedBoardModel)encryptedBoard);
            ResponseBoardModel responseBoard = new ResponseBoardModel(decryptedBoard);
            responseBoard.setOwnerData(ownerData);
            return responseBoard;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return boardsWithOwnerData;
    }

    @Override
    public List<ResponseBoardModel> getFullBoardList() throws Exception {
        boolean isAdmin = this.dhUserService.isLoggedUserAdmin();
        if (!isAdmin) {
            log.error("Problems getting all boards: User not allowed.");
            throw new BadRequestException(403, "User not allowed to get all boards.");
        }
        List<EncryptedBoardModel> encrypedBoards = this.boardsRepo.getFullBoardsList();
        List<ResponseBoardModel> boardsWithOwnersData = this.populateOwnersData(encrypedBoards);
        return boardsWithOwnersData;
    }

    @Override
    public ResponseChangeOwnerModel changeWallboardsOwner(List<String> boardIds, String newOwner) {
        boolean isAdmin = this.dhUserService.isLoggedUserAdmin();
        if (!isAdmin) {
            log.error("Problems changing boards owner: User not allowed to change owner.");
            return new ResponseChangeOwnerModel(new LinkedList<String>(), boardIds);
        }
        AppUser newOwnerData = this.dhUserService.getUserByKey(newOwner, false);
        if (newOwnerData == null || newOwnerData.getActive() != null && !newOwnerData.getActive().booleanValue()) {
            log.error("Problems changing boards owner: New owner not found or not active.");
            return new ResponseChangeOwnerModel(new LinkedList<String>(), boardIds);
        }
        LinkedList<String> updatedBoards = new LinkedList<String>();
        LinkedList<String> errorBoards = new LinkedList<String>();
        for (String boardId : boardIds) {
            try {
                BoardModel board = this.boardsController.getBoard(boardId);
                if (board == null) {
                    errorBoards.add(boardId);
                    continue;
                }
                board.setOwner(newOwner);
                this.boardsRepo.updateBoard(this.boardsController.generateEncryptedBoard(board));
                updatedBoards.add(boardId);
            }
            catch (Exception e) {
                log.error("Problems changing boards owner", (Throwable)e);
                errorBoards.add(boardId);
            }
        }
        return new ResponseChangeOwnerModel(updatedBoards, errorBoards);
    }

    @Override
    public boolean disablePublicLink(String boardId) throws Exception {
        boolean isAdmin = this.dhUserService.isLoggedUserAdmin();
        if (!isAdmin) {
            log.error("Problems changing boards owner: User not allowed to change owner.");
            throw new BadRequestException(403, "User not allowed to disable public link.");
        }
        BoardModel board = this.boardsController.getBoard(boardId);
        if (board == null) {
            throw new BadRequestException(404, "Board not found.");
        }
        if (board.getSharing() == null || !board.getSharing().getPublic().booleanValue()) {
            return false;
        }
        board.setSharing(null);
        this.boardsRepo.updateBoard(this.boardsController.generateEncryptedBoard(board));
        return true;
    }
}

