/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.server.functions;

import com.roninpixels.dashboardhub.connectors.impl.confluence.common.models.TasksOptions;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class GetInlineTasksServerFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetInlineTasksServerFunc.class);
    public static final String EXTRACT_TASK_DATA_PATTERN = "<li(.+?>)(.+?)</li>";
    public static final String REST_INLINETASKS_REPORT = "/rest/inlinetasks/1/task-report";
    public static final String EXTRACT_USERNAME_PATTERN = "data-username=\"(.+?)\"";
    private final ServerConnector connector;
    private DHObjectMapper mapper = new DHObjectMapperImpl();

    static List<Map> getAssignees(String taskHtml, List users) {
        ArrayList<Map> assignees = new ArrayList<Map>();
        List<String> userNames = GetInlineTasksServerFunc.getTaskUsernames(taskHtml);
        userNames.stream().forEach(userName -> {
            List usersFound = users.stream().filter(_user -> {
                Map userMap = (Map)_user;
                return userMap.get("username").equals(userName);
            }).collect(Collectors.toList());
            if (usersFound.size() > 0) {
                assignees.add((Map)usersFound.get(0));
            }
        });
        return assignees;
    }

    static final String parseTaskBody(String taskHtml) {
        String taskHmtlParsed = "";
        Pattern pattern = Pattern.compile(EXTRACT_TASK_DATA_PATTERN);
        Matcher matcher = pattern.matcher(taskHtml);
        while (matcher.find()) {
            taskHmtlParsed = matcher.group(2);
        }
        return taskHmtlParsed.replaceAll("<a ", "<a target='_blank' ");
    }

    public GetInlineTasksServerFunc(ServerConnector connector) {
        this.connector = connector;
    }

    public static final Map formatTask(Map task, List users) {
        HashMap formattedTask = new HashMap();
        formattedTask.put("taskId", task.get("taskId"));
        formattedTask.put("assignees", GetInlineTasksServerFunc.getAssignees((String)task.get("taskHtml"), users));
        formattedTask.put("title", task.get("pageTitle"));
        formattedTask.put("path", task.get("pageUrl"));
        formattedTask.put("body", GetInlineTasksServerFunc.parseTaskBody((String)task.get("taskHtml")));
        return formattedTask;
    }

    public static final List<String> getTaskUsernames(String taskHtml) {
        ArrayList<String> usernames = new ArrayList<String>();
        Pattern pattern = Pattern.compile(EXTRACT_USERNAME_PATTERN);
        Matcher matcher = pattern.matcher(taskHtml);
        while (matcher.find()) {
            usernames.add(matcher.group(1));
        }
        return usernames;
    }

    public List<Map> getData(Map params) throws IOException {
        List spaces = params.containsKey("spaces") ? (List)params.get("spaces") : Arrays.asList(new Object[0]);
        String status = params.containsKey("status") ? (String)params.get("status") : null;
        TasksOptions tasksOptions = new TasksOptions(spaces, status);
        String reportParameters = this.mapper.writeValueAsString(tasksOptions);
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("pageSize", 30);
        reportParams.put("reportParameters", reportParameters);
        ArrayList<Map> fullTasks = new ArrayList<Map>();
        int page = 0;
        boolean hasMore = true;
        while (hasMore) {
            reportParams.put("pageIndex", page++);
            ResponseEntity<Map> responseEntity = this.connector.executeRequest(REST_INLINETASKS_REPORT, reportParams, Map.class);
            ResponseChecker.checkStatus(responseEntity);
            Map result = (Map)responseEntity.getBody();
            List tasks = (List)result.get("detailLines");
            fullTasks.addAll(tasks);
            int currentPage = (Integer)result.get("currentPage") + 1;
            int totalPages = (Integer)result.get("totalPages");
            hasMore = currentPage < totalPages && fullTasks.size() < 300;
        }
        return fullTasks;
    }
}

