/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.BitbucketCloudBaseFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetPullRequestsFunc
extends BitbucketCloudBaseFunc {
    private static final Logger log = LoggerFactory.getLogger(GetPullRequestsFunc.class);
    private final String workspace;

    public GetPullRequestsFunc(ServerConnector serverConnector, String workspace) {
        super(serverConnector);
        this.workspace = workspace;
    }

    public ResponseEntity<List> exec(String repoSlug, Map<String, String> params, boolean loadAll) {
        String path = String.format("/2.0/repositories/%s/%s/pullrequests", this.workspace, repoSlug);
        List prs = this.getData(path, params, 1000, loadAll);
        prs.stream().forEach(pr -> pr.put("repo_slug", repoSlug));
        return new ResponseEntity((Object)prs, HttpStatus.OK);
    }
}

