/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.dashboardfilters.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.roninpixels.dashboardhub.config.DashboardHubConfig;
import com.roninpixels.dashboardhub.config.FrontendConfigurationService;
import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.FrontendConfigModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.services.DHUserService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FilterRulesConfigAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(FilterRulesConfigAction.class);
    @Autowired
    private DashboardHubConfig dashboardHubConfig;
    @Autowired
    private DHUserService dhUserService;
    @Autowired
    private FrontendConfigurationService configService;
    @Autowired
    private AccessManagementController accessManagementController;

    public String filterRulesSettings() {
        return this.dhUserService.isLoggedUserAdmin() != false ? "success" : "unauthorized";
    }

    public String filterRulesPageDashboard() {
        return this.dhUserService.isLoggedUserAdmin() != false ? "success" : "unauthorized";
    }

    public String filterRulesDashboardHubDashboard() {
        return this.dhUserService.isLoggedUserAdmin() != false ? "success" : "unauthorized";
    }

    public DashboardHubConfig getDashboardHubConfig() {
        return this.dashboardHubConfig;
    }

    public String getConfig() {
        try {
            FrontendConfigModel config = this.configService.createConfig();
            config.setAppAdminConfig(true);
            return this.configService.serializeConfig(config);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    public String getAppConfig() {
        AppConfigModel appConfig = this.accessManagementController.getConfig();
        appConfig.setRestrictedAccess(false);
        try {
            return this.configService.serializeConfig(appConfig);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }
}

