/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config.action;

import com.roninpixels.dashboardhub.config.DashboardHubConfig;
import com.roninpixels.dashboardhub.config.FrontendConfigurationService;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.FrontendConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.ProtectedWallboard;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.controllers.PerformanceSettingsController;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.SharedBoardModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHShowSharedAction
implements DHAction {
    private static final Logger log = LoggerFactory.getLogger(DHShowSharedAction.class);
    @Inject
    private FrontendConfigurationService configService;
    @Inject
    private DashboardHubConfig dashboardHubConfig;
    @Inject
    private BoardsController boardsController;
    @Inject
    private PerformanceSettingsController performanceSettingsController;
    @Inject
    private DHObjectMapper mapper;
    private TokenContentModel tokenData;

    @Override
    public void setToken(TokenContentModel tokenContent) {
        this.tokenData = tokenContent;
    }

    @Override
    public DashboardHubConfig getDashboardHubConfig() {
        return this.dashboardHubConfig;
    }

    @Override
    public String getConfig() {
        try {
            FrontendConfigModel config = this.configService.createConfig(true);
            config.setExternal(true);
            this.setSharedBoard(config);
            return this.configService.serializeConfig(config);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    private void setSharedBoard(FrontendConfigModel config) {
        if (this.tokenData != null) {
            try {
                BoardModel board = this.boardsController.getUserBoard(this.tokenData.getUsserAccountId(), this.tokenData.getBoardId(), this.tokenData.getGlobal());
                SharedBoardModel sharedBoard = SharedBoardModel.shortBean(board);
                config.setSharedBoard(this.mapper.writeValueAsString(sharedBoard));
                if (board.getSharing().getPassword() != null) {
                    config.setProtectedWallboard(new ProtectedWallboard(board.getId(), board.getToken()));
                } else {
                    config.setWallboard(this.mapper.writeValueAsString(board));
                }
            }
            catch (Exception e) {
                log.error("Problems getting a board for public sharing -> " + this.tokenData.getBoardId(), (Throwable)e);
            }
        }
    }

    @Override
    public String getAppConfig() {
        AppConfigModel appConfig = new AppConfigModel();
        appConfig.setRestrictedAccess(false);
        appConfig.setPerformanceSettings(this.performanceSettingsController.getPerformanceSettings());
        try {
            return this.configService.serializeConfig(appConfig);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    public boolean isExternal() {
        return true;
    }
}

