/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.statusPage.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.StatusPageConnector;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/statuspage/v1/pages")
public class PagesV1Endpoint {
    private static final Logger log = LoggerFactory.getLogger(PagesV1Endpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response getPages(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            StatusPageConnector statusPageConnector = (StatusPageConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ResponseEntity<String> response = statusPageConnector.getPages();
            int status = response.getStatusCode().value();
            if (status < 400) {
                return ResponseBuilder.create(status, response.getBody()).build();
            }
            return ResponseBuilder.create(400, response.getBody()).build();
        }
        catch (Exception e) {
            log.error("Problems getting pages", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

