/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/jira/v1")
public class StatusEndpoint {
    private static final Logger log = LoggerFactory.getLogger(StatusEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Response getStatus(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ResponseEntity<String> res = jira.getStatuses();
            return GenericJiraEndpoint.generateResponse(res, "status");
        }
        catch (Exception e) {
            log.error("Problems getting status values", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @GET
    @AnonymousAllowed
    @Path(value="/statuscategory")
    @Produces(value={"application/json"})
    public Response getStatusCategory(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ResponseEntity<String> res = jira.getStatusCategory();
            return GenericJiraEndpoint.generateResponse(res, "statusCategory");
        }
        catch (Exception e) {
            log.error("Problems getting status categories values", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

