/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.boards.userPreferences;

import com.roninpixels.dashboardhub.controllers.BoardUserPreferencesController;
import com.roninpixels.dashboardhub.web.models.BoardUserPreferenceModel;
import com.roninpixels.dashboardhub.web.rest.dashboardHub.boards.userPreferences.BoardUserPreferenceMessageModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BoardUserPreferencesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(BoardUserPreferencesEndpoint.class);
    @Inject
    private BoardUserPreferencesController boardUserPreferencesController;

    public Response getBoardUserPreferences(@NotNull @PathParam(value="boardId") String boardId) {
        try {
            BoardUserPreferenceModel boardUserPreference = this.boardUserPreferencesController.getBoardUserPreference(boardId);
            if (boardUserPreference == null) {
                boardUserPreference = this.boardUserPreferencesController.createOrUpdateBoardUserPreference(boardId, "{}");
            }
            return ResponseBuilder.ok(new BoardUserPreferenceMessageModel(boardUserPreference.getBoardId(), boardUserPreference.getFilter())).build();
        }
        catch (Exception e) {
            log.error("Problems getting a boardUserPreference with boardId -> " + boardId, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public Response setBoardUserPreferences(BoardUserPreferenceMessageModel message) {
        try {
            BoardUserPreferenceModel newBoardUserPreference = this.boardUserPreferencesController.createOrUpdateBoardUserPreference(message.getBoardId(), message.getFilter());
            return ResponseBuilder.ok(new BoardUserPreferenceMessageModel(newBoardUserPreference.getBoardId(), newBoardUserPreference.getFilter())).build();
        }
        catch (Exception e) {
            log.error("Problems creating or updating a boardUserPreference with boardId -> " + message.getBoardId(), (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

