/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest;

import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import com.roninpixels.dashboardhub.web.validator.DHValidator;
import com.roninpixels.dashboardhub.web.validator.DHValidatorImpl;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.model.Parameter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorInterceptor
implements ResourceInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ValidatorInterceptor.class);
    private DHValidator validator;

    public ValidatorInterceptor() {
        try {
            this.validator = new DHValidatorImpl(Validation.buildDefaultValidatorFactory().getValidator());
        }
        catch (Exception e) {
            log.warn("Dashboard Hub validator cannot be initialized");
        }
    }

    private List getCandidates(MethodInvocation methodInvocation) {
        LinkedList<Object> candidatesToValidate = new LinkedList<Object>();
        List paramTypes = methodInvocation.getMethod().getParameters();
        Object[] parameters = methodInvocation.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter paramType = (Parameter)paramTypes.get(i);
            if (!paramType.isAnnotationPresent(Valid.class)) continue;
            candidatesToValidate.add(parameters[i]);
        }
        return candidatesToValidate;
    }

    private Response generateReponseError(Set<ConstraintViolation> violationSet) {
        int statusCode = 400;
        HashMap<String, Serializable> errorData = new HashMap<String, Serializable>();
        HashMap errors = new HashMap();
        errorData.put("status-code", Integer.valueOf(400));
        errorData.put("errors", errors);
        violationSet.stream().forEach(cv -> errors.put(cv.getPropertyPath().toString(), cv.getMessage()));
        return ResponseBuilder.create(400, errorData).build();
    }

    public void intercept(MethodInvocation methodInvocation) throws IllegalAccessException, InvocationTargetException {
        if (this.validator == null) {
            methodInvocation.invoke();
            return;
        }
        List candidatesToValidate = this.getCandidates(methodInvocation);
        Set<ConstraintViolation> violationSet = this.validator.validate(candidatesToValidate);
        if (violationSet.isEmpty()) {
            methodInvocation.invoke();
        } else {
            HttpResponseContext reps = methodInvocation.getHttpContext().getResponse();
            reps.setResponse(this.generateReponseError(violationSet));
        }
    }
}

