/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.jcma.entityExporters.impl;

import com.roninpixels.dashboardhub.controllers.DashboardGadgetsController;
import com.roninpixels.dashboardhub.jcma.entityExporters.GadgetEnricher;
import com.roninpixels.dashboardhub.jcma.entityExporters.GenericRepositoryExporter;
import com.roninpixels.dashboardhub.store.DHDashboardGadgetsRepository;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import com.roninpixels.dashboardhub.web.models.EncryptedDashboardGadgetModel;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;

public class DashboardGadgetsExporter
extends GenericRepositoryExporter<EncryptedDashboardGadgetModel> {
    public static final String LABEL = "SavedGadgetEntity";
    @Inject
    private DashboardGadgetsController controller;
    @Autowired(required=false)
    private Provider<List<GadgetEnricher>> enricherProvider;

    @Inject
    public DashboardGadgetsExporter(DHDashboardGadgetsRepository repo) {
        super(repo);
    }

    @Override
    protected Object prepareToExport(EncryptedDashboardGadgetModel modelObj) {
        DashboardGadgetModel gadget = this.controller.decryptDashboardGadget(modelObj);
        if (this.enricherProvider.get() != null && !((List)this.enricherProvider.get()).isEmpty()) {
            ((List)this.enricherProvider.get()).stream().forEach(enricher -> enricher.enrich(gadget));
        }
        gadget.setToken(null);
        return gadget;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }
}

