/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.projectrak;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.projectrak.PQLSearchConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.projectrak.ProjectrakGadgetRequesterBase;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PQLSearch
extends ProjectrakGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(PQLSearch.class);

    List<String> getNeededFields(PQLSearchConfig config) {
        List<Object> aggFields = new LinkedList();
        LinkedList<String> requestFields = new LinkedList<String>();
        switch (config.getView()) {
            case "multilinechart": 
            case "stackedbarchart": 
            case "groupedbarchart": 
            case "stackedareachart": {
                requestFields.add(config.getChartGroup());
            }
            case "funnelchart": 
            case "tilechart": 
            case "linechart": 
            case "piechart": 
            case "barchart": 
            case "areachart": {
                requestFields.add(config.getChartBy());
                requestFields.add(config.getChartAggregation().get(1));
            }
        }
        if (config.getGroup() != null) {
            aggFields = config.getAggregations().stream().map(pair -> (String)pair.get(1)).filter(field -> !config.getFields().contains(field)).collect(Collectors.toList());
        }
        requestFields.addAll(config.getFields());
        requestFields.addAll(aggFields);
        return requestFields;
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        PQLSearchConfig config = GadgetRequesterUtils.getConfig(gadget, PQLSearchConfig.class);
        try {
            List<String> fieldKeys = this.getNeededFields(config);
            List<Integer> indexedFields = this.getFieldsIds(fieldKeys);
            List<Map> data = this.connector.execPQL(config.getPQL(), indexedFields, true);
            HashMap<String, List<Map>> response = new HashMap<String, List<Map>>();
            response.put("projects", data);
            return response;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

