/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDateUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.TimePeriodOption;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;

public class TimePeriodUtil {
    private static final DateTimeFormatter dtf = JiraDateUtils.DEFAULT_DATE_FORMATTER;

    public static boolean matchOptionTimePeriod(TimePeriodOption option, String releasedDate) {
        ZonedDateTime releasedDT = JiraDateUtils.getZonedDateTime(releasedDate);
        return TimePeriodUtil.matchOptionTimePeriod(option, releasedDT);
    }

    public static boolean matchOptionTimePeriod(TimePeriodOption option, Date releasedDate) {
        ZonedDateTime dateTime = releasedDate.toInstant().atZone(ZoneId.systemDefault());
        return TimePeriodUtil.matchOptionTimePeriod(option, dateTime);
    }

    public static boolean matchOptionTimePeriod(TimePeriodOption option, ZonedDateTime releasedDT) {
        switch (option) {
            case TODAY: {
                return TimePeriodUtil.checkIsIncludedInLastXDays(releasedDT, 0L);
            }
            case LAST_7_DAYS: {
                return TimePeriodUtil.checkIsIncludedInLastXDays(releasedDT, 7L);
            }
            case LAST_14_DAYS: {
                return TimePeriodUtil.checkIsIncludedInLastXDays(releasedDT, 14L);
            }
            case LAST_MONTH: {
                ZonedDateTime currentDT = ZonedDateTime.now().minusMonths(1L);
                return releasedDT.getYear() == currentDT.getYear() && releasedDT.getMonthValue() == currentDT.getMonthValue();
            }
            case CURRENT_MONTH: {
                ZonedDateTime currentDT = ZonedDateTime.now();
                return releasedDT.getYear() == currentDT.getYear() && releasedDT.getMonthValue() == currentDT.getMonthValue();
            }
            case LAST_QUARTER: {
                return TimePeriodUtil.checkIsIncludedInQuarter(releasedDT, -3L);
            }
            case CURRENT_QUARTER: {
                return TimePeriodUtil.checkIsIncludedInQuarter(releasedDT, 0L);
            }
            case LAST_YEAR: {
                return releasedDT.getYear() == ZonedDateTime.now().minusYears(1L).getYear();
            }
            case CURRENT_YEAR: {
                return releasedDT.getYear() == ZonedDateTime.now().getYear();
            }
        }
        return false;
    }

    private static boolean checkIsIncludedInQuarter(ZonedDateTime target, long monthsOffset) {
        ZonedDateTime pivotDT = ZonedDateTime.now().plusMonths(monthsOffset);
        int quarterNumber = (pivotDT.getMonthValue() - 1) / 3;
        ZonedDateTime firstQMoment = pivotDT.withMonth(quarterNumber * 3 + 1).with(TemporalAdjusters.firstDayOfMonth()).toLocalDate().atStartOfDay(pivotDT.getZone());
        ZonedDateTime lastQMoment = firstQMoment.plusMonths(3L).with(TemporalAdjusters.firstDayOfMonth()).toLocalDate().atStartOfDay(pivotDT.getZone());
        return (firstQMoment.isEqual(target) || firstQMoment.isBefore(target)) && lastQMoment.isAfter(target);
    }

    private static boolean checkIsIncludedInLastXDays(ZonedDateTime target, long lastDays) {
        ZonedDateTime firstMoment = LocalDate.now().minusDays(lastDays).atStartOfDay(target.getZone());
        ZonedDateTime lastMoment = LocalDate.now().plusDays(1L).atStartOfDay(target.getZone());
        return (firstMoment.isEqual(target) || firstMoment.isBefore(target)) && lastMoment.isAfter(target);
    }
}

