/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.roninpixels.dashboardhub.config.frontedModel.PerformanceSettingsModel;
import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import com.roninpixels.dashboardhub.controllers.PerformanceSettingsController;
import com.roninpixels.dashboardhub.exceptions.NotAuthorizedException;
import com.roninpixels.dashboardhub.services.DHUserService;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class PerformanceSettingsControllerImpl
implements PerformanceSettingsController {
    static final String PROP_NAME_REFRESH_TIME = "com.roninpixels.dashboardhub:performance.settings.refreshTime";
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Inject
    private JiraIntegrationProperties jiraIntegrationProperties;
    @Inject
    private DHUserService userService;

    private void updateRefreshTime(String refreshTime) {
        if (!REFRESH_TIME_ALLOWED.contains(refreshTime)) {
            throw new IllegalArgumentException("refreshTime value is not valid: " + refreshTime);
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put(PROP_NAME_REFRESH_TIME, (Object)refreshTime);
    }

    private void updateMaxIssueNumber(Integer newMaxIssuesValue) {
        if (!JiraIntegrationProperties.MAX_ISSUES_ALLOWED.contains(newMaxIssuesValue)) {
            throw new IllegalArgumentException("maxIssueNumber value is not valid: " + newMaxIssuesValue);
        }
        this.jiraIntegrationProperties.setMaxIssues(newMaxIssuesValue);
    }

    @Override
    public void updatePerformanceSettings(PerformanceSettingsModel newSettings) {
        Integer maxParallelRqs;
        Integer maxIssues;
        if (!this.userService.isLoggedUserAdmin().booleanValue()) {
            throw new NotAuthorizedException();
        }
        String refreshTime = newSettings.getRefreshTime();
        if (refreshTime != null) {
            this.updateRefreshTime(refreshTime);
        }
        if ((maxIssues = newSettings.getMaxIssueNumber()) != null) {
            this.updateMaxIssueNumber(maxIssues);
        }
        if ((maxParallelRqs = newSettings.getParallelRequests()) != null) {
            this.jiraIntegrationProperties.setParallelRequesters(maxParallelRqs);
        }
    }

    @Override
    public PerformanceSettingsModel getPerformanceSettings() {
        Integer parallelRqs;
        Integer maxIssues;
        PerformanceSettingsModel settings = new PerformanceSettingsModel();
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object refreshTime = pluginSettings.get(PROP_NAME_REFRESH_TIME);
        if (refreshTime != null) {
            settings.setRefreshTime(refreshTime.toString());
        }
        if ((maxIssues = this.jiraIntegrationProperties.getMaxIssues()) != null) {
            settings.setMaxIssueNumber(maxIssues);
        }
        if ((parallelRqs = this.jiraIntegrationProperties.getParallelRequesters()) != null) {
            settings.setParallelRequests(parallelRqs);
        }
        return settings;
    }
}

