/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.genericServer;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnectorConfiguration;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
public class ServerConnectorFactoryImpl
implements ServerConnectorFactory {
    @Inject
    private Provider<ServerConnector> serverConnectorProvider;

    @Bean
    @Scope(value="prototype")
    public ServerConnector getServerConnector() {
        return new ServerConnector();
    }

    @Override
    public ServerConnector getServerConnector(DatasourceModel ds, RestAuthStrategy authStrategy) {
        return this.getServerConnector(ds, authStrategy, null);
    }

    @Override
    public ServerConnector getServerConnector(DatasourceModel ds, RestAuthStrategy authStrategy, ServerConnectorConfiguration config) {
        ServerConnector sc = (ServerConnector)this.serverConnectorProvider.get();
        sc.init(ds, authStrategy, config);
        return sc;
    }
}

