/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.BitbucketCloudBaseFunc;
import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.GetCommitFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetPrInfoFunc
extends BitbucketCloudBaseFunc {
    private static final Logger log = LoggerFactory.getLogger(GetPrInfoFunc.class);
    private final String workspace;

    public GetPrInfoFunc(ServerConnector serverConnector, String workspace) {
        super(serverConnector);
        this.workspace = workspace;
    }

    Map getPullRequest(Map pullRequest) {
        String repoSlug = (String)pullRequest.get("repo_slug");
        Integer repoId = (Integer)pullRequest.get("id");
        String path = String.format("/2.0/repositories/%s/%s/pullrequests/%s", this.workspace, repoSlug, repoId);
        ResponseEntity<Map> response = this.connector.executeRequest(path, Collections.emptyMap(), Map.class);
        this.checkStatus(response);
        return (Map)response.getBody();
    }

    Map getCommit(Map pullRequest) {
        String repoSlug = (String)pullRequest.get("repo_slug");
        String hash = (String)((Map)((Map)pullRequest.get("source")).get("commit")).get("hash");
        ResponseEntity<Map> response = new GetCommitFunc(this.connector, this.workspace).exec(repoSlug, hash);
        return (Map)response.getBody();
    }

    public ResponseEntity<Map> exec(Map pullRequest, List<String> expand) {
        Map prData = this.getPullRequest(pullRequest);
        if (expand.contains("commit")) {
            Map commitData = this.getCommit(pullRequest);
            prData.put("commit", commitData);
        }
        return new ResponseEntity((Object)prData, HttpStatus.OK);
    }
}

