/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.jira.api;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.http.ResponseEntity;

public class GenericJiraEndpoint {
    public static Response generateResponse(ResponseEntity<?> res) {
        try {
            return GenericJiraEndpoint.generateResponse(res, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Response generateResponse(ResponseEntity<?> res, String rootName) throws IOException {
        int statusCode = res.getStatusCode().value();
        if (statusCode >= 400) {
            return Response.status((int)statusCode).entity(res.getBody()).build();
        }
        HashMap<String, Object> responseEntity = res.getBody();
        if (rootName != null) {
            HashMap<String, Object> newValue = new HashMap<String, Object>();
            if (responseEntity instanceof String) {
                DHObjectMapperImpl mapper = new DHObjectMapperImpl();
                List fields = mapper.readValue(res.getBody().toString(), List.class);
                newValue.put(rootName, fields);
            } else {
                newValue.put(rootName, responseEntity);
            }
            responseEntity = newValue;
        }
        return Response.status((int)res.getStatusCode().value()).entity((Object)responseEntity).build();
    }

    public static Response generateResponse(BadRequestToSourceException bre) {
        ResponseEntity sourceResponse = bre.getResponseEntity();
        Object entity = sourceResponse != null ? sourceResponse.getBody() : bre.getBody();
        return ResponseBuilder.createErrorFrom(bre);
    }
}

