/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.dashboardHub.dashboardGadgets;

import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetMessageModel;
import com.roninpixels.dashboardhub.web.rest.dashboardHub.dashboardGadgets.DashboardGadgetsEndpoint;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.io.IOException;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/gadget")
public class DashboardGadgetsEndpointWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardGadgetsEndpointWrapper.class);
    @Inject
    private DashboardGadgetsEndpoint dashboardGadgetsEndpoint;
    @Inject
    private DHObjectMapper mapper;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addDashboardGadget(String message) {
        DashboardGadgetMessageModel dashboardGadgetMessage = null;
        try {
            dashboardGadgetMessage = this.mapper.readValue(message, DashboardGadgetMessageModel.class);
        }
        catch (IOException e) {
            return ResponseBuilder.createParseErrorResponse(e);
        }
        return this.dashboardGadgetsEndpoint.addDashboardGadget(dashboardGadgetMessage);
    }

    @DELETE
    @Path(value="/{containerId}/{itemId}")
    @Produces(value={"application/json"})
    public Response deleteDashboardGadget(@NotNull @PathParam(value="containerId") String containerId, @NotNull @PathParam(value="itemId") String itemId) {
        return this.dashboardGadgetsEndpoint.deleteDashboardGadget(containerId, itemId);
    }

    @GET
    @Path(value="/{containerId}/id/{itemId}")
    @Produces(value={"application/json"})
    public Response getDashboardGadget(@NotNull @PathParam(value="containerId") String containerId, @NotNull @PathParam(value="itemId") String itemId) {
        return this.dashboardGadgetsEndpoint.getDashboardGadget(containerId, itemId);
    }
}

