/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.permissions;

import com.roninpixels.dashboardhub.utils.permissions.BoardRestrictionsConfig;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;
import com.roninpixels.dashboardhub.web.models.UserGroupsModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RestrictionsUtil {
    public static Map<String, List<String>> breakDownUserGroups(RestrictionsModel restrictions) {
        UserGroupsModel userGroups = restrictions.getUserGroups();
        return RestrictionsUtil.breakDownUserGroups(Stream.concat(userGroups.getCanView().stream(), userGroups.getCanEdit().stream()).collect(Collectors.toList()));
    }

    public static Map<String, List<String>> breakDownUserGroups(List<String> groupAndUsers) {
        LinkedList<String> userKeys = new LinkedList<String>();
        LinkedList<String> groupNames = new LinkedList<String>();
        if (groupAndUsers != null && !groupAndUsers.isEmpty()) {
            block9: for (String element : groupAndUsers) {
                String elem = element.trim();
                if (elem.isEmpty()) continue;
                ArrayList<String> substrings = new ArrayList<String>(Arrays.asList(elem.split(":")));
                String prefix = (String)substrings.remove(0);
                String id = String.join((CharSequence)":", substrings);
                switch (prefix) {
                    case "accountId": 
                    case "userId": {
                        userKeys.add(id);
                        continue block9;
                    }
                    case "groupId": {
                        groupNames.add(id);
                        continue block9;
                    }
                }
                throw new RuntimeException("Not supported: " + elem + " in " + groupAndUsers);
            }
        }
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        data.put("users", userKeys);
        data.put("groups", groupNames);
        return data;
    }

    public static Map<String, List<String>> breakDownUserGroups(String groupAndUsers) {
        return RestrictionsUtil.breakDownUserGroups(Arrays.asList(groupAndUsers.split(",")));
    }

    public static BoardRestrictionsConfig getBoardRestrictionsConfig(RestrictionsModel restrictions) {
        return new BoardRestrictionsConfig(restrictions);
    }
}

