/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.roninpixels.dashboardhub.config.action.DHJiraGadgetShowAction;
import com.roninpixels.dashboardhub.controllers.DashboardGadgetsController;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroGadgetServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MacroGadgetServlet.class);
    private static final String RESOURCE = "resources";
    private static final String TEMPLATE_PATH = "/templates/dashboard-hub-gadget-macro.vm";
    @ComponentImport
    private TemplateRenderer templateRenderer;
    @Inject
    private Provider<DHJiraGadgetShowAction> actionProvider;
    @Inject
    private DashboardGadgetsController dashboardGadgetsController;
    @Inject
    private DHObjectMapper mapper;
    private String resources;

    @Inject
    public MacroGadgetServlet(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void init() {
        this.resources = this.getServletConfig().getInitParameter(RESOURCE);
    }

    private String getSerializedGadget(String containerId, String gadgetId) throws IOException {
        DashboardGadgetModel gadget = this.dashboardGadgetsController.getDashboardGadget(containerId, gadgetId);
        if (gadget == null) {
            return "";
        }
        String rawGadget = this.mapper.writeValueAsString(gadget);
        return Base64.getEncoder().encodeToString(rawGadget.getBytes(StandardCharsets.UTF_8));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("resp", resp);
        context.put("urlMode", UrlMode.AUTO);
        context.put("scope", Collections.singletonList(this.resources));
        DHJiraGadgetShowAction action = (DHJiraGadgetShowAction)this.actionProvider.get();
        context.put("dh", action);
        context.put("action", action);
        String gadget = this.getSerializedGadget(req.getParameter("containerId"), req.getParameter("gadgetId"));
        if (gadget != "") {
            context.put("gadget", gadget);
        }
        boolean isEditor = Boolean.parseBoolean(req.getParameter("isEditor"));
        HashMap<String, Boolean> globalVars = new HashMap<String, Boolean>();
        globalVars.put("isMacroEditor", isEditor);
        context.put("isMacroEditor", isEditor);
        globalVars.put("isMacro", !isEditor);
        context.put("globalVars", globalVars);
        String template = TEMPLATE_PATH;
        this.templateRenderer.render(template, context, (Writer)resp.getWriter());
    }
}

