/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.jcma.entityExporters.impl;

import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.jcma.entityExporters.BoardEnricher;
import com.roninpixels.dashboardhub.jcma.entityExporters.GenericRepositoryExporter;
import com.roninpixels.dashboardhub.store.DHBoardsRepository;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.EncryptedBoardModel;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BoardsExporter
extends GenericRepositoryExporter<EncryptedBoardModel> {
    private static final Logger log = LoggerFactory.getLogger(BoardsExporter.class);
    public static final String LABEL = "SavedBoardEntity";
    @Inject
    private BoardsController boardsController;
    @Autowired(required=false)
    private Provider<List<BoardEnricher>> enricherProvider;

    @Inject
    public BoardsExporter(DHBoardsRepository repo) {
        super(repo);
    }

    @Override
    protected Object prepareToExport(EncryptedBoardModel modelObj) {
        BoardModel board = this.boardsController.decryptBoard(modelObj);
        if (this.enricherProvider.get() != null && !((List)this.enricherProvider.get()).isEmpty()) {
            ((List)this.enricherProvider.get()).stream().forEach(enricher -> enricher.enrich(board));
        }
        return board;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }
}

