/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie.OpsTeamConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.opsgenie.OpsgenieGadgetRequesterBase;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class OpsTeam
extends OpsgenieGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(OpsTeam.class);

    Map getEmptyTeam() {
        HashMap team = new HashMap();
        team.put("members", Collections.emptyList());
        return team;
    }

    String getTeamIdFrom(OpsTeamConfig config) {
        return (String)config.getTeams().get(0).get("id");
    }

    Map getTeam(String id) throws Exception {
        ResponseEntity<String> response = this.connector.getTeam(id);
        Map responseBody = this.checkStatusAndParse(response, Map.class);
        return responseBody.getOrDefault("data", null);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        OpsTeamConfig config = GadgetRequesterUtils.getConfig(gadget, OpsTeamConfig.class);
        boolean getUsers = this.checkGetUsers(extraParams);
        String teamId = this.getTeamIdFrom(config);
        try {
            Map team = this.getTeam(teamId);
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (getUsers && team != null) {
                data.put("users", this.getUsers());
            }
            data.put("team", team == null ? this.getEmptyTeam() : team);
            return data;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

