/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources;

import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatasourceGenerator {
    private static final Logger log = LoggerFactory.getLogger(DatasourceGenerator.class);
    @Inject
    private List<Generator> generators;

    @PostConstruct
    public void init() {
        log.debug("Generators already configured: " + this.generators);
    }

    Generator getDsGenerator(DatasourceModel def) {
        Generator gen = this.generators.stream().filter(generator -> generator.match(def)).findAny().orElse(null);
        if (gen == null) {
            throw new RuntimeException("Datasource type not supported: " + def.getProduct());
        }
        return gen;
    }

    public DatasourceModel generateDatasource(DatasourceModel def, List<DatasourceModel> datasources) {
        try {
            Generator aGenerator = this.getDsGenerator(def);
            return aGenerator.generateDS(def, datasources, def.getOptions(), null, null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

