/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.opsgenie.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetOpsGenieDataFunc {
    private static final Logger log = LoggerFactory.getLogger(GetOpsGenieDataFunc.class);
    private final String path;
    private final ServerConnector connector;

    public GetOpsGenieDataFunc(ServerConnector serverConnector, String path) {
        this.connector = serverConnector;
        this.path = path;
    }

    public ResponseEntity<List> exec(Map<String, String> params) {
        boolean loadAll = Boolean.parseBoolean(params.getOrDefault("loadAll", "false"));
        int currentOffset = 0;
        HashMap<String, String> mParams = params != null ? new HashMap<String, String>(params) : new HashMap();
        mParams.putIfAbsent("offset", (String)((Object)Integer.valueOf(currentOffset)));
        mParams.putIfAbsent("limit", (String)((Object)Integer.valueOf(100)));
        mParams.remove("loadAll");
        int responseCode = 200;
        LinkedList result = new LinkedList();
        boolean getMoreData = true;
        while (getMoreData) {
            ResponseEntity<Map> response = this.connector.executeRequest(this.path, mParams, Map.class);
            responseCode = response.getStatusCode().value();
            if (responseCode >= 400) {
                throw new BadRequestToSourceException(response);
            }
            Map responseData = (Map)response.getBody();
            List values = (List)responseData.get("data");
            result.addAll(values);
            String nextURL = this.getNextURL(responseData);
            getMoreData = nextURL != null && loadAll;
            if (!getMoreData) continue;
            mParams.put("offset", (String)((Object)Integer.valueOf(++currentOffset)));
        }
        return new ResponseEntity(result, HttpStatus.valueOf((int)responseCode));
    }

    String getNextURL(Map responseBody) {
        Map paging = (Map)responseBody.get("paging");
        return paging != null ? (String)paging.get("next") : null;
    }
}

