/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions;

import com.roninpixels.dashboardhub.connectors.impl.bitbucket.cloud.functions.BitbucketCloudBaseFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetPrsFunc
extends BitbucketCloudBaseFunc {
    private static final Logger log = LoggerFactory.getLogger(GetPrsFunc.class);
    private final String workspace;

    public GetPrsFunc(ServerConnector serverConnector, String workspace) {
        super(serverConnector);
        this.workspace = workspace;
    }

    public ResponseEntity<List> exec(String repoSlug) {
        String path = String.format("/2.0/repositories/%s/%s/pullrequests", this.workspace, repoSlug);
        List prs = this.getData(path, Collections.emptyMap(), 1000, true);
        prs.stream().forEach(pr -> pr.put("repo_slug", repoSlug));
        return new ResponseEntity((Object)prs, HttpStatus.OK);
    }
}

