/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.JiraAuthenticatorStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.factories.JiraRestConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.confluence.server.ConfluenceRestConnector;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.stereotype.Component;

@Component
public class LocalSelfConnectorFactory
implements ConnectorFactory {
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory restAuthStrategyFactory;
    @Inject
    private ApplicationPropertiesAccesor applicationPropertiesAccesor;
    @Inject
    private Provider<ServerConnector> serverConnectorsProvider;
    @Inject
    private JiraRestConnectorFactory jiraRestConnectorFactory;

    private ServerConnector getServerConnector(DatasourceModel ds) {
        RestAuthStrategy authStrategy = this.restAuthStrategyFactory.getRestAuthStrategy(JiraAuthenticatorStrategy.class, ds);
        ServerConnector sc = this.serverConnectorFactory.getServerConnector(ds, authStrategy);
        return sc;
    }

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        ds.setUrl(this.applicationPropertiesAccesor.getAppProperty("baseURL", null));
        ServerConnector serverConnector = this.getServerConnector(ds);
        switch (ds.getProduct()) {
            case "jira": {
                return this.jiraRestConnectorFactory.createDefaultConnector(serverConnector);
            }
            case "confluence": {
                return new ConfluenceRestConnector(serverConnector);
            }
        }
        throw new RuntimeException("Product not supported: " + ds.getProduct());
    }

    @Override
    public boolean match(DatasourceModel ds) {
        String appName = this.applicationPropertiesAccesor.getApplicationName();
        return "direct".equals(ds.getType()) && appName.equals(ds.getProduct());
    }
}

