/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.factories;

import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.BearerTokenAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.DatasourceBasicAuthStrategy;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import com.roninpixels.dashboardhub.connectors.factories.JiraRestConnectorFactory;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.cloud.JiraRestCloudConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.server.JiraRestConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.RestAuthStrategyFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.ServerConnectorFactory;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class JiraRestConnectorFactoryImpl
implements JiraRestConnectorFactory {
    private static final List VALID_TYPES = Arrays.asList("datacenter", "direct", "cloud");
    @Inject
    private ServerConnectorFactory serverConnectorFactory;
    @Inject
    private RestAuthStrategyFactory authStrategyFactory;
    @Inject
    private Crypto mCrypto;
    @Inject
    private DHObjectMapper mapper;
    @Inject
    private JiraIntegrationProperties dhIntegrationProps;

    @Override
    public JiraRestConnector createDefaultConnector(ServerConnector connector4Jira) {
        return new JiraRestConnector(connector4Jira, this.dhIntegrationProps);
    }

    @Override
    public DHConnector createConnector(DatasourceModel ds) {
        RestAuthStrategy strategy = this.getRestAuthStrategy(ds);
        ServerConnector internalServerConnector = this.serverConnectorFactory.getServerConnector(ds, strategy);
        if (ds.getType().equals("cloud")) {
            return new JiraRestCloudConnector(internalServerConnector, this.dhIntegrationProps);
        }
        return this.createDefaultConnector(internalServerConnector);
    }

    private RestAuthStrategy getRestAuthStrategy(DatasourceModel ds) {
        if (this.hasPersonalAccessToken(ds)) {
            return this.authStrategyFactory.getRestAuthStrategy(BearerTokenAuthStrategy.class, ds);
        }
        return this.authStrategyFactory.getRestAuthStrategy(DatasourceBasicAuthStrategy.class, ds);
    }

    private boolean hasPersonalAccessToken(DatasourceModel ds) {
        if (ds.getToken() != null) {
            try {
                String tokenData = this.mCrypto.decryptBackend(ds.getToken());
                DsOptionsModel token = this.mapper.readValue(tokenData, DsOptionsModel.class);
                if (token.getOtherConfig() != null && token.getOtherConfig().get("options") != null) {
                    Map tokenOptions = (Map)token.getOtherConfig().get("options");
                    return tokenOptions.containsKey("token");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error on hasPersonalAccessToken", e);
            }
        }
        return false;
    }

    @Override
    public boolean match(DatasourceModel ds) {
        return ds.getProduct().equals("jira") && (VALID_TYPES.contains(ds.getType()) || ds.getOptions() != null && ds.getOptions().getOption("datacenter") != null);
    }
}

