/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.configs;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JiraIntegrationPropertiesImpl
implements JiraIntegrationProperties {
    private static final Logger log = LoggerFactory.getLogger(JiraIntegrationPropertiesImpl.class);
    public static final String PROP_NAME_MAX_ISSUES = "com.roninpixels.dashboardhub:integration.jira.maxIssues";
    public static final int DEFAULT_MAX_ISSUES = 2500;
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;

    @Override
    public Integer getMaxIssues() {
        String value = this.getValue(PROP_NAME_MAX_ISSUES);
        return value != null ? Integer.parseInt(value) : 2500;
    }

    @Override
    public void setMaxIssues(Integer newValue) {
        if (newValue < 500 || newValue > 100000) {
            throw new IllegalArgumentException("Invalid value - MAX ISSUES: " + newValue);
        }
        this.setValue(PROP_NAME_MAX_ISSUES, newValue.toString());
    }

    private String getValue(String propName) {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        Object value = settings.get(propName);
        return value == null ? null : value.toString();
    }

    private void setValue(String propName, String newValue) {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        settings.put(propName, (Object)newValue);
    }
}

