/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy.strategies;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.web.util.UriComponentsBuilder;

public class OpsgenieTokenAuthStrategy
implements RestAuthStrategy {
    private final String P_API_TOKEN = "apiKey";
    private final DatasourceModel datasource;
    private final DHObjectMapper mapper = new DHObjectMapperImpl();
    @Inject
    private Crypto mCrypto;

    public OpsgenieTokenAuthStrategy(DatasourceModel datasource) {
        this.datasource = datasource;
    }

    @Override
    public Request applyAuthenticationStrategy(Request request, UriComponentsBuilder builder) {
        String apiToken;
        DsOptionsModel dsOptions = this.getOptions(this.datasource.getToken());
        Map options = dsOptions.getOption("options", Map.class);
        String string = apiToken = options != null ? (String)options.get("apiKey") : null;
        if (apiToken != null) {
            String authValue = String.format("GenieKey %s", apiToken);
            return request.addHeader("Authorization", authValue);
        }
        throw new RuntimeException("API Token not defined");
    }

    @Override
    public void analyzeHeaders(Response response) {
    }

    private DsOptionsModel getOptions(String token) {
        try {
            return this.mapper.readValue(this.mCrypto.decryptBackend(token), DsOptionsModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

