/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy.strategies;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.RestAuthStrategy;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.web.util.UriComponentsBuilder;

public class BearerTokenAuthStrategy
implements RestAuthStrategy {
    private final String P_TOKEN = "token";
    private final DatasourceModel datasource;
    @Inject
    private DHObjectMapper mapper;
    @Inject
    private Crypto mCrypto;

    public BearerTokenAuthStrategy(DatasourceModel datasource) {
        this.datasource = datasource;
    }

    @Override
    public Request applyAuthenticationStrategy(Request request, UriComponentsBuilder builder) {
        String apiToken;
        DsOptionsModel dsOptions = this.getOptions(this.datasource.getToken());
        Map options = dsOptions.getOption("options", Map.class);
        String string = apiToken = options != null ? (String)options.get("token") : null;
        if (apiToken != null) {
            String authValue = String.format("Bearer %s", apiToken);
            return request.addHeader("Authorization", authValue);
        }
        throw new RuntimeException("Bearer Token not defined");
    }

    private DsOptionsModel getOptions(String token) {
        try {
            return this.mapper.readValue(this.mCrypto.decryptBackend(token), DsOptionsModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void analyzeHeaders(Response response) {
    }
}

