/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.confluence.config;

import com.roninpixels.dashboardhub.config.dhDefault.DefaultDatasourceCreator;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ConfluenceDefaultDatasourceCreator
implements DefaultDatasourceCreator {
    @Inject
    private DHUserService dhUserService;
    @Inject
    private ApplicationPropertiesAccesor applicationProperties;

    @Override
    public DatasourceModel findDefaultDatasource(List<DatasourceModel> datasources) {
        String userKey = this.dhUserService.getLoggedInUserKey();
        return datasources.stream().filter(ds -> "confluence".equals(ds.getProduct()) && "direct".equals(ds.getType()) && userKey.equals(ds.getCreator()) && ds.getFirst() != false).findAny().orElse(null);
    }

    @Override
    public boolean isDefaultDatasourceProvided() {
        return true;
    }

    @Override
    public DatasourceModel createDefaultDatasource() {
        String baseURL = this.applicationProperties.getAppProperty("baseURL", null);
        DatasourceModel ds = new DatasourceModel();
        ds.setId(UUID.randomUUID().toString());
        ds.setCreator(this.dhUserService.getLoggedInUserKey());
        ds.setPrivate(true);
        ds.setName("This Confluence Instance");
        ds.setProduct("confluence");
        ds.setType("direct");
        ds.setUrl(baseURL);
        ds.setCreated(new Date());
        ds.setFirst(true);
        return ds;
    }
}

