/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.utils;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ResponseBuilder.class);
    private static DHObjectMapper mapper = new DHObjectMapperImpl();

    public static final Response.ResponseBuilder create(int status) {
        return ResponseBuilder.create(status, null);
    }

    public static final Response.ResponseBuilder create(int status, Object entity) {
        Response.ResponseBuilder rb = Response.status((int)status);
        if (entity != null) {
            try {
                rb.entity((Object)mapper.writeValueAsString(entity));
            }
            catch (IOException e) {
                log.error("Error on ResponseBuilder creating a response", (Throwable)e);
                return rb.status(500);
            }
        }
        return rb;
    }

    public static final Response.ResponseBuilder ok(Object entity) {
        return ResponseBuilder.create(200, entity);
    }

    public static final Response createErrorFrom(GadgetRequesterException gre) {
        return ResponseBuilder.create(gre.getCode(), ResponseBuilder.createErrorMessage(gre)).build();
    }

    public static final Response createErrorFrom(BadRequestToSourceException bre) {
        Object entity = bre.getBody() != null ? bre.getBody() : bre.getResponseEntity().getBody();
        return ResponseBuilder.create(bre.getStatusCode(), entity).build();
    }

    static final Map<String, String> createErrorMessage(GadgetRequesterException gre) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("error", gre.getMessage());
        return response;
    }

    public static Response create(Response resp) {
        if (resp.getEntity() != null && !(resp.getEntity() instanceof String)) {
            return ResponseBuilder.create(resp.getStatus(), resp.getEntity()).build();
        }
        return resp;
    }

    public static Response createParseErrorResponse(IOException e) {
        return Response.status((int)400).entity((Object)e.getMessage()).build();
    }
}

