/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.opsgenie.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.OpsgenieConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/opsgenie/v1/teams")
public class TeamsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(TeamsEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response getTeams(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            OpsgenieConnector connector = (OpsgenieConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("loadAll", "true");
            ResponseEntity<List> response = connector.listTeams(params);
            int status = response.getStatusCode().value();
            if (status < 400) {
                return ResponseBuilder.create(status, response.getBody()).build();
            }
            return ResponseBuilder.create(400, response.getBody()).build();
        }
        catch (BadRequestToSourceException se) {
            log.error("Problems getting opsgenie teams", (Throwable)se);
            return Response.status((int)se.getStatusCode()).build();
        }
        catch (Exception e) {
            log.error("Problems getting opsgenie teams", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

