/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.confluence.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import com.roninpixels.dashboardhub.web.rest.confluence.api.GetSpacesRequest;
import com.roninpixels.dashboardhub.web.rest.jira.api.GenericJiraEndpoint;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/confluence/v1/spaces")
public class SpaceEndpoint {
    private static final Logger log = LoggerFactory.getLogger(SpaceEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    @POST
    @Produces(value={"application/json"})
    public Response getSpaces(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, GetSpacesRequest request) {
        try {
            ConfluenceConnector confluence = (ConfluenceConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("all", true);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("status", "current");
            if (request != null && request.getKeys() != null && !request.getKeys().isEmpty()) {
                params.put("keys", request.getKeys());
            }
            return GenericJiraEndpoint.generateResponse(confluence.getSpaces(params, options));
        }
        catch (Exception e) {
            log.error("Problems getting boards", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    public Response searchSpaces(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @QueryParam(value="searchTerm") String searchTerm, @QueryParam(value="limit") Integer limit) {
        try {
            ConfluenceConnector confluence = (ConfluenceConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("searchTerm", searchTerm);
            params.put("limit", limit == null ? 10 : limit);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("all", false);
            List content = confluence.searchCQL(params, options);
            String link = confluence.getURL().split("/wiki")[0];
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("content", content);
            data.put("link", link);
            return ResponseBuilder.ok(data).build();
        }
        catch (Exception e) {
            log.error("Problems searching spaces", (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

