/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.license.rulesImpl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.roninpixels.dashboardhub.license.DHLicenseRule;
import com.roninpixels.dashboardhub.license.LicenseStatusJsonBean;
import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class DEVModeRule
implements DHLicenseRule {
    private static final String TK_DEV_MODE = "ronin.dev.mode";
    @Inject
    @ComponentImport
    private PluginLicenseManager licenseManager;
    @Inject
    private ApplicationPropertiesAccesor applicationProperties;

    public boolean isDevModeEnabled() {
        String debugPropValue = this.applicationProperties.getSystemProperty(TK_DEV_MODE, "false");
        return Boolean.parseBoolean(debugPropValue);
    }

    @Override
    public boolean isLicensed() {
        return this.isDevModeEnabled();
    }

    @Override
    public LicenseStatusJsonBean getLicenseStatus() {
        String key = this.licenseManager.getPluginKey();
        LicenseStatusJsonBean bean = new LicenseStatusJsonBean();
        bean.setValid(this.isLicensed());
        bean.setKey(key);
        return bean;
    }
}

