/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.model.TimeRange;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

public class JSMDataUtil2 {
    public static ZonedDateTime getDate(TimeRange timeRange) {
        ZonedDateTime date;
        switch (timeRange.getRange()) {
            case "day": {
                date = ZonedDateTime.now().minusDays(timeRange.getAmount().intValue());
                break;
            }
            case "week": {
                date = ZonedDateTime.now().minusWeeks(timeRange.getAmount().intValue());
                break;
            }
            default: {
                date = ZonedDateTime.now().minusMonths(timeRange.getAmount().intValue());
            }
        }
        return date;
    }

    public static String getDateAsString(TimeRange timeRange) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("YYYY/MM/dd");
        return JSMDataUtil2.getDate(timeRange).format(dtf);
    }

    public static String getPreviousDateAsString(TimeRange timeRange, int multiplier) {
        TimeRange newTR = new TimeRange();
        newTR.setRange(timeRange.getRange());
        newTR.setAmount(timeRange.getAmount() * multiplier);
        return JSMDataUtil2.getDateAsString(newTR);
    }

    public static String getResolutionQuery(String date, boolean isServer) {
        return JSMDataUtil2.getResolutionQuery(date, ">=", isServer);
    }

    public static String getResolutionQuery(String date, String comparison, boolean isServer) {
        return !isServer ? String.format("(resolutiondate %s '%s' OR (statusCategory = Done and statusCategoryChangedDate %s '%s'))", comparison, date, comparison, date) : String.format("resolutiondate %s '%s'", comparison, date);
    }

    public static String getMatchingFieldsSubQuery(List<Field> matchingFields) {
        return matchingFields.stream().map(field -> {
            String name = (String)((List)field.getOtherFields().get("clauseNames")).get(0);
            return String.format("'%s' = completed()", name);
        }).collect(Collectors.joining(" OR "));
    }

    public static List<String> getKeysOrIds(List<Field> fields) {
        return fields.stream().map(field -> field.getKey() != null ? field.getKey() : field.getId()).collect(Collectors.toList());
    }
}

