/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket;

import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.BitbucketGadgetRequesterBase;
import com.roninpixels.dashboardhub.gadgetsRequesters.bitbucket.configBeans.GRWithReposConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;

public class Deployments
extends BitbucketGadgetRequesterBase {
    static final int PAGE_SIZE = 6;
    static final Comparator<Map> DP_UPDATED_COMPARATOR = Comparator.comparing(pl -> ZonedDateTime.parse((String)pl.get("last_update_time")));
    static final String NO_PROJECT = null;

    List<Map> getDeployments(String repo, Map<String, String> params) {
        ResponseEntity<List> resDeployments = this.connector.getDeployments(repo, params, false);
        this.checkStatus(resDeployments);
        return (List)resDeployments.getBody();
    }

    Map getRepository(String repo) {
        ResponseEntity<Map> resRepo = this.connector.getRepository(NO_PROJECT, repo);
        this.checkStatus(resRepo);
        return (Map)resRepo.getBody();
    }

    List<Map> getDeploymentsBySlug(String repo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", "1");
        params.put("pagelen", "6");
        params.put("sort", "-state.started_on");
        Map repository = this.getRepository(repo);
        return this.getDeployments(repo, params).stream().map(deployment -> {
            deployment.put("repoSlug", repo);
            deployment.put("repository", repository);
            return deployment;
        }).collect(Collectors.toList());
    }

    List<Map> getDeployments(List<String> repos) {
        return repos.parallelStream().map(repo -> this.getDeploymentsBySlug((String)repo)).flatMap(Collection::stream).sorted(DP_UPDATED_COMPARATOR.reversed()).limit(6L).collect(Collectors.toList());
    }

    Map loadEnvironment(String repoSlug, String envUuid) {
        ResponseEntity<Map> res = this.connector.getEnvironment(repoSlug, envUuid);
        this.checkStatus(res);
        return (Map)res.getBody();
    }

    Map loadCommitData(String slug, String hash) {
        try {
            ResponseEntity<Map> res = this.connector.getCommit(NO_PROJECT, slug, hash);
            this.checkStatus(res);
            return (Map)res.getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    Map loadPipelineData(String slug, String pipelineUuid) {
        ResponseEntity<Map> res = this.connector.getPipeline(slug, pipelineUuid);
        this.checkStatus(res);
        return (Map)res.getBody();
    }

    void enrichDeployments(List<Map> deployments) {
        deployments.parallelStream().forEach(deployment -> {
            String slug = (String)deployment.get("repoSlug");
            String envUuid = (String)((Map)deployment.get("environment")).get("uuid");
            Map release = (Map)deployment.get("release");
            String commitHash = (String)((Map)release.get("commit")).get("hash");
            String pipelineUuid = (String)((Map)release.get("pipeline")).get("uuid");
            deployment.put("environmentData", this.loadEnvironment(slug, envUuid));
            deployment.put("pipelineData", this.loadPipelineData(slug, pipelineUuid));
            Map commitData = this.loadCommitData(slug, commitHash);
            if (commitData != null) {
                deployment.put("commitData", commitData);
            }
        });
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        GRWithReposConfig config = GadgetRequesterUtils.getConfig(gadget, GRWithReposConfig.class);
        List<Map> deployments = this.getDeployments(config.getRepositoriesSlugs());
        this.enrichDeployments(deployments);
        HashMap<String, List<Map>> data = new HashMap<String, List<Map>>();
        data.put("deployments", deployments);
        return data;
    }
}

