/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.datasources.generators;

import com.roninpixels.dashboardhub.datasources.generators.Generator;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component(value="dilbert")
public class DilbertDs
implements Generator {
    public static final String PRODUCT = Product.DILBERT.value();
    private static final String BASE_URL = "https://feedsservice.amuniversal.com";
    private static final String USER = "sgs_feeds";
    private static final String PASS = "!sgs_feeds";
    @Inject
    private Crypto mCrypto;
    @Inject
    private DHObjectMapper mapper;

    @Override
    public boolean match(DatasourceModel def) {
        return PRODUCT.equals(def.getProduct());
    }

    @Override
    public DatasourceModel generateDS(DatasourceModel dsDef, List<DatasourceModel> datasources, DsOptionsModel options, Object req, Object res) throws Exception {
        String id = UUID.randomUUID().toString();
        DatasourceModel newDs = new DatasourceModel();
        newDs.setProduct(PRODUCT);
        newDs.setUrl(BASE_URL);
        newDs.setName("dilbert-ds");
        newDs.setId(id);
        newDs.setPrivate(true);
        newDs.setCreator("dh-system");
        newDs.setCreated(new Date());
        DsOptionsModel actualOptions = new DsOptionsModel();
        actualOptions.addOtherConfig("username", USER);
        actualOptions.addOtherConfig("password", PASS);
        newDs.setOptions(actualOptions);
        DsOptionsModel tokenData = this.generateDsOptions(newDs, actualOptions);
        String token = this.mCrypto.encryptBackend(this.mapper.writeValueAsString(tokenData));
        newDs.setToken(token);
        return newDs;
    }

    DsOptionsModel generateDsOptions(DatasourceModel ds, DsOptionsModel options) {
        DsOptionsModel tokenData = new DsOptionsModel();
        tokenData.addOtherConfig("id", ds.getId());
        tokenData.addOtherConfig("name", ds.getName());
        tokenData.addOtherConfig("url", ds.getUrl());
        tokenData.addOtherConfig("product", ds.getProduct());
        tokenData.addOtherConfig("options", options);
        return tokenData;
    }

    public void validate(DatasourceModel dsDef, List<DatasourceModel> datasources) {
    }
}

