/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.gadgets;

import com.roninpixels.dashboardhub.services.ApplicationPropertiesAccesor;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.utils.TokenGenerator;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class GadgetTokenController {
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private ApplicationPropertiesAccesor applicationProperties;

    public DashboardGadgetModel updateToken(DashboardGadgetModel dashboardGadget) {
        AppUser user = this.dhUserService.getLoggedInUser();
        String ownerKey = dashboardGadget.getOwner() != null ? dashboardGadget.getOwner() : user.getKey();
        TokenContentModel tc = new TokenContentModel();
        tc.setBoardId(dashboardGadget.getId());
        tc.setGadgetId(dashboardGadget.getId());
        tc.setContainerId(dashboardGadget.getContainerId());
        tc.setItemId(dashboardGadget.getItemId());
        tc.setUsserAccountId(ownerKey);
        tc.setProduct(dashboardGadget.getProduct());
        String token = this.tokenGenerator.generate(tc);
        dashboardGadget.setToken(token);
        return dashboardGadget;
    }

    public String getToken(String id, String containerId, String itemId) {
        AppUser user = this.dhUserService.getLoggedInUser();
        TokenContentModel tc = new TokenContentModel();
        tc.setBoardId(id);
        tc.setGadgetId(id);
        tc.setContainerId(containerId);
        tc.setItemId(itemId);
        tc.setUsserAccountId(user.getKey());
        tc.setProduct(this.applicationProperties.getDisplayName());
        return this.tokenGenerator.generate(tc);
    }
}

