/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.bitbucket.api;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.BitbucketConnector;
import com.roninpixels.dashboardhub.globals.Product;
import com.roninpixels.dashboardhub.globals.ProductHosting;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

@Path(value="/bitbucket/v1/projects")
public class ProjectsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ProjectsEndpoint.class);
    @Inject
    private ConnectorsFactory connectorsFactory;
    @Inject
    private Crypto crypto;
    @Inject
    private DHObjectMapper mapper;

    DatasourceModel generateTemporalDatasource(String url, String apiToken) throws Exception {
        DatasourceModel ds = new DatasourceModel();
        ds.setName("bitbucket temporal");
        ds.setUrl(url);
        ds.setProduct(Product.BITBUCKET.value());
        ds.setType(ProductHosting.DATACENTER.value());
        DsOptionsModel dsOptions = new DsOptionsModel();
        dsOptions.addOtherConfig("hostType", ProductHosting.DATACENTER.value());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("token", apiToken);
        dsOptions.addOtherConfig("options", options);
        ds.setOptions(dsOptions);
        String token = this.mapper.writeValueAsString(dsOptions);
        ds.setToken(this.crypto.encryptBackend(token));
        return ds;
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response searchProjects(@NotNull @QueryParam(value="url") String url, @NotNull @QueryParam(value="token") String token) {
        try {
            DatasourceModel ds = this.generateTemporalDatasource(url, token);
            BitbucketConnector connector = (BitbucketConnector)this.connectorsFactory.getConnector(ds);
            ResponseEntity<List> sourceResponse = connector.getProjects(Collections.emptyMap(), true);
            int status = sourceResponse.getStatusCodeValue();
            if (status < 400) {
                return Response.status((int)status).entity(sourceResponse.getBody()).build();
            }
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            log.error("Problems searching Bitbucket projects at -> " + url, (Throwable)e);
            return Response.status((int)400).build();
        }
    }
}

