/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import org.springframework.http.ResponseEntity;

public class ResponseChecker {
    public static void checkStatus(ResponseEntity<?> response) throws BadRequestToSourceException {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }

    public static <T> T checkStatusAndParse(ResponseEntity<String> response, Class<T> clazz) throws Exception {
        ResponseChecker.checkStatus(response);
        DHObjectMapperImpl mapper = new DHObjectMapperImpl();
        return mapper.readValue((String)response.getBody(), clazz);
    }

    public static <T> T checkStatusAndParse(ResponseEntity<String> response, TypeReference<T> valueTypeRef) throws Exception {
        ResponseChecker.checkStatus(response);
        DHObjectMapperImpl mapper = new DHObjectMapperImpl();
        return mapper.readValue((String)response.getBody(), valueTypeRef);
    }
}

