/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.software;

import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.JQLSearch;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeInStatus
extends JQLSearch {
    private static final Logger log = LoggerFactory.getLogger(TimeInStatus.class);
    private static final List<String> EXTRA_EXPAND = Arrays.asList("changelog");
    private static final List<String> CHANGELOG_FIELDS = Arrays.asList("status", "assignee");

    public TimeInStatus() {
        super(EXTRA_EXPAND);
    }

    void ensureChangelogAreCompleted(Map<String, Object> data) {
        List issues = (List)data.get("issues");
        issues.parallelStream().forEach(issue -> {
            int total;
            String issueId = (String)issue.get("id");
            Map changelog = (Map)issue.get("changelog");
            int maxResults = (Integer)changelog.get("maxResults");
            if (maxResults != (total = ((Integer)changelog.get("total")).intValue())) {
                try {
                    Map newChangeLog = this.jiraConnector.getIssueChangelog(Long.parseLong(issueId));
                    issue.put("changelog", newChangeLog);
                }
                catch (Exception e) {
                    log.warn("Problems getting the whole changelog of the issue: " + issueId, (Throwable)e);
                }
            }
        });
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        Map data = (Map)super.getData(gadget, extraParams);
        this.ensureChangelogAreCompleted(data);
        JiraDataUtils.reduceHistory((List)data.get("issues"), CHANGELOG_FIELDS);
        return data;
    }
}

